<!doctype html>
<html lang="id">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= esc($title ?? 'Import Data Kelulusan') ?></title>

  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="icon" href="<?= base_url('assets/images/logo1.png') ?>" type="image/png">

  <style>
    body{background:#f6f8fb}

    /* ===== SIDEBAR (ASLI – TIDAK DIUBAH STRUKTURNYA) ===== */
    .sidebar{width:280px;min-height:100vh;overflow-y:auto}
    .sidebar a{text-decoration:none}
    .sidebar .active{background:rgba(13,110,253,.12);border-radius:.5rem}
    .sub-menu{padding-left:1rem}
    .sub-menu .list-group-item{font-size:.9rem;border:none}

    .menu-toggle{cursor:pointer;position:relative}
    .menu-toggle::after{
      content:'▼';
      position:absolute;
      right:1rem;
      font-size:.75rem;
      transition:.3s
    }
    .menu-toggle.collapsed::after{transform:rotate(-90deg)}

    /* ===== KONTEN ===== */
    h1{font-size:26px;font-weight:800;color:#0f172a}

    p, ul, pre{font-size:14px;color:#334155}

    pre{
      background:#f8fafc;
      border:1px solid #e5e7eb;
      border-radius:12px;
      padding:14px;
    }

    form{
      background:#fff;
      padding:24px;
      border-radius:18px;
      box-shadow:0 10px 30px rgba(16,24,40,.08);
      max-width:620px;
    }

    input[type=file]{
      width:100%;
      padding:10px;
      border-radius:12px;
      border:1px solid #cbd5e1;
    }

    button{
      background:#2563eb;
      color:#fff;
      border:none;
      padding:10px 18px;
      border-radius:999px;
      font-weight:700;
    }

    /* ===== ALERT (TANPA UBAH HTML ASLI) ===== */
    div[style*="#fee2e2"]{
      background:#fef2f2!important;
      border-color:#ef4444!important;
      color:#7f1d1d;
      font-size:14px;
    }

    div[style*="#d1fae5"]{
      background:#ecfdf5!important;
      border-color:#10b981!important;
      color:#065f46;
      font-size:14px;
    }

    /* ===== RESPONSIVE ===== */
    .hamburger{display:none;font-size:1.6rem;color:#fff;cursor:pointer}
    .sidebar-overlay{
      display:none;
      position:fixed;
      inset:0;
      background:rgba(0,0,0,.45);
      z-index:1040;
    }

    @media(max-width:991px){
      .hamburger{display:block}
      .sidebar{
        position:fixed;
        top:0;left:0;
        z-index:1050;
        background:#fff;
        transform:translateX(-100%);
        transition:.3s
      }
      .sidebar.show{transform:translateX(0)}
      .sidebar-overlay.show{display:block}
    }
    
    /* ===== TAMBAHAN RESPONSIVE (AMAN) ===== */
    .hamburger {
      display: none;
      font-size: 1.6rem;
      color: #fff;
      cursor: pointer;
    }

    .sidebar-overlay {
      display: none;
      position: fixed;
      inset: 0;
      background: rgba(0,0,0,.45);
      z-index: 1040;
    }

    @media (max-width: 991px) {
      .hamburger {
        display: block;
      }

      .sidebar {
        position: fixed;
        top: 0;
        left: 0;
        z-index: 1050;
        background: #fff;
        transform: translateX(-100%);
        transition: transform .3s ease;
      }

      .sidebar.show {
        transform: translateX(0);
      }

      .sidebar-overlay.show {
        display: block;
      }
    }
  </style>
</head>

<body>


<body class="bg-light">

<nav class="navbar navbar-expand-lg bg-primary navbar-dark">
  <div class="container-fluid">
    <a class="navbar-brand fw-bold" href="<?= site_url('admin') ?>">Welcome back Admin</a>

    <!-- TAMBAHAN: HAMBURGER (TIDAK MENGHAPUS APA PUN) -->
    <span class="hamburger ms-auto me-3" onclick="toggleSidebar()">☰</span>

    <div class="d-flex gap-2 align-items-center">
      <span class="text-white small">Halo, <?= esc(auth()->user()->username ?? 'Admin') ?></span>
      <a class="btn btn-outline-light btn-sm" href="<?= site_url('logout') ?>">Logout</a>
    </div>
  </div>
</nav>

<!-- TAMBAHAN: OVERLAY -->
<div class="sidebar-overlay" onclick="toggleSidebar()"></div>

<div class="d-flex">

  <!-- ===== SIDEBAR ASLI KAMU (UTUH, TIDAK DIHAPUS) ===== -->
  <aside class="sidebar bg-white border-end p-3" id="sidebar">
    <div class="fw-bold mb-2">Admin Panel</div>

    <?php
      $uri = service('uri')->getPath();

      $isInfoSekolahActive = ($uri === 'admin' || $uri === 'admin/' ||
                              str_starts_with($uri, 'admin/branding') ||
                              str_starts_with($uri, 'admin/visi-misi') ||
                              str_starts_with($uri, 'admin/kepsek') ||
                              str_starts_with($uri, 'admin/video-profile') ||
                              str_starts_with($uri, 'admin/data-sekolah') ||
                              str_starts_with($uri, 'admin/footer'));

      $isBeritaActive = (str_starts_with($uri, 'admin/berita') ||
                        str_starts_with($uri, 'admin/pengumuman') ||
                        str_starts_with($uri, 'admin/kelulusan') ||
                        str_starts_with($uri, 'admin/kegiatan') ||
                        str_starts_with($uri, 'admin/prestasi'));

      $isGaleriActive = (str_starts_with($uri, 'admin/galeri') ||
                        str_starts_with($uri, 'admin/guru-staf') ||
                        str_starts_with($uri, 'admin/siswa') ||
                        str_starts_with($uri, 'admin/video') ||
                        str_starts_with($uri, 'admin/ekstrakulikuler'));
    ?>


  <div class="list-group list-group-flush">

    <a class="list-group-item menu-toggle <?= $isInfoSekolahActive?'':'collapsed' ?>"
       data-bs-toggle="collapse" href="#infoMenu">Informasi Sekolah</a>

    <div class="collapse <?= $isInfoSekolahActive?'show':'' ?>" id="infoMenu">
      <div class="sub-menu">
        <a class="list-group-item" href="<?= site_url('admin') ?>">Dashboard</a>
        <a class="list-group-item" href="<?= site_url('admin/visi-misi') ?>">Visi & Misi</a>
        <a class="list-group-item" href="<?= site_url('admin/kepsek') ?>">Kata Sambutan</a>
        <a class="list-group-item" href="<?= site_url('admin/video-profile') ?>">Video Profile</a>
        <a class="list-group-item" href="<?= site_url('admin/data-sekolah') ?>">Statistika</a>
        <a class="list-group-item" href="<?= site_url('admin/footer') ?>">Footer</a>
      </div>
    </div>

    <a class="list-group-item menu-toggle <?= $isBeritaActive?'':'collapsed' ?>"
       data-bs-toggle="collapse" href="#beritaMenu">Berita</a>

    <div class="collapse <?= $isBeritaActive?'show':'' ?>" id="beritaMenu">
      <div class="sub-menu">
        <a class="list-group-item" href="<?= site_url('admin/pengumuman') ?>">Pengumuman</a>
        <a class="list-group-item" href="<?= site_url('admin/kelulusan') ?>">Pengumuman Kelulusan</a>
      </div>
    </div>

    <a class="list-group-item menu-toggle <?= $isGaleriActive?'':'collapsed' ?>"
       data-bs-toggle="collapse" href="#galeriMenu">Galeri</a>

    <div class="collapse <?= $isGaleriActive?'show':'' ?>" id="galeriMenu">
      <div class="sub-menu">
        <a class="list-group-item" href="<?= site_url('admin/guru-staf') ?>">Guru & Staf</a>
        <a class="list-group-item" href="<?= site_url('admin/siswa') ?>">Siswa</a>
        <a class="list-group-item" href="<?= site_url('admin/video') ?>">Video</a>
        <a class="list-group-item" href="<?= site_url('admin/ekstrakurikuler') ?>">Ekstrakurikuler</a>
      </div>
    </div>

    <a class="list-group-item" href="<?= site_url('admin/tentang') ?>">Tentang</a>
    <a class="list-group-item" href="<?= site_url('admin/password') ?>">Ubah Password</a>
  </div>
</aside>

<!-- ================= MAIN CONTENT ================= -->
<main class="flex-grow-1 p-4">

  <h1><?= esc($title ?? 'Import Data Kelulusan') ?></h1>

  <?php if (!empty($errors)): ?>
    <div style="padding:10px;background:#fee2e2;border:1px solid #f87171;border-radius:10px;margin:10px 0;">
      <ul style="margin:0;padding-left:18px;">
        <?php foreach ((array)$errors as $e): ?>
          <li><?= esc($e) ?></li>
        <?php endforeach; ?>
      </ul>
    </div>
  <?php endif; ?>

  <?php if (!empty($success)): ?>
    <div style="padding:10px;background:#d1fae5;border:1px solid #34d399;border-radius:10px;margin:10px 0;">
      <?= esc($success) ?>
    </div>
  <?php endif; ?>

  <p>
    Upload <b>CSV</b> dengan header wajib:
    <code>tahun,nisn,nama,kelas,status,tgl_lahir</code>
    (opsional: <code>keterangan</code>)
  </p>

  <pre>tahun,nisn,nama,kelas,status,tgl_lahir,keterangan
2025/2026,1234567890,Budi Santoso,XII IPA 1,2007-01-12 atau 01-12-2007,LULUS,
2025/2026,1234567891,Siti Aisyah,XII IPS 2,2007-05-01 atau 02-05-2007,TIDAK LULUS,Silakan hubungi wali kelas</pre>

  <form method="post" enctype="multipart/form-data"
        action="<?= site_url('admin/kelulusan/import') ?>">
    <?= csrf_field() ?>
    <input type="file" name="csv" accept=".csv" required class="mb-3">
    <button type="submit">Import</button>
    <a href="<?= site_url('admin/kelulusan') ?>" class="ms-2">Kembali</a>
  </form>

</main>
</div>

<script>
  function toggleSidebar() {
    document.getElementById('sidebar').classList.toggle('show');
    document.querySelector('.sidebar-overlay').classList.toggle('show');
  }
</script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
